#include <QFileInfo>
#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>
#include <QSqlDatabase>

#include "datamodel.h"
#include "datetime.h"
int main(int argc, char* argv[])
{
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

    QGuiApplication app(argc, argv);

    QSqlDatabase db = QSqlDatabase::addDatabase(QStringLiteral("QSQLITE"));
    db.setDatabaseName("/usr/share/medical-data/medData.db");
    db.open();

    DateTime myDateTime(nullptr);
    DataModel dataModel(nullptr, db);
    dataModel.setTable(QStringLiteral("patients"));
    dataModel.select();

    QQmlApplicationEngine engine;
    engine.rootContext()->setContextProperty("dateTime", &myDateTime);
    engine.rootContext()->setContextProperty("dataModel", &dataModel);
    const QUrl url(QStringLiteral("qrc:/main.qml"));
    QObject::connect(
        &engine, &QQmlApplicationEngine::objectCreated,
        &app, [url](QObject* obj, const QUrl& objUrl) {
            if (!obj && url == objUrl)
                QCoreApplication::exit(-1);
        },
        Qt::QueuedConnection);
    engine.load(url);

    return app.exec();
}
